# -*- coding: utf-8 -*-
"""
Created on Tue Aug  9 16:09:49 2022

@author: reinoutubbink
"""

import numpy as np
import matplotlib.pyplot as plt

Fth = 700   #film thickness, nm
Tth = 1e5   #total cell thickness, nm
N = 490     #number of total cells
H = 30      #number of film cells
IFC = 60    #number of IF cells
dxIF = 0.3  #nm
dxf = (Fth - 5*dxIF)/(H-5)
dxs = (Tth - IFC*dxIF - Fth) / (N - H - IFC - 1)
q = 1.602e-19
mu = 3e-10
kT = 1.380e-23*300
dx = 27.94e-9


CELL = np.loadtxt('0.8V_0.1Vs_0.1M.csv', delimiter=',')
CELL2 = np.loadtxt('0.8V_1Vs_0.1M.csv', delimiter=',')
for i in range(30): #To compensate for porosity of the film (50%), we multiply all concentrations by 2 to be able to directly compare concentrations in and out of the film. 
    CELL[i] = 2*CELL[i]
    CELL[N+i] = 2*CELL[N+i]
    CELL[2*N+1] = 2*CELL[2*N+i]
    CELL2[i] = 2*CELL2[i]
    CELL2[N+i] = 2*CELL2[N+i]
    CELL2[2*N+1] = 2*CELL2[2*N+i]
dis1 = np.linspace(0,dxf*(H-5),(H-5))
dis2 = np.linspace(dis1[-1] + dxIF ,dis1[-1] + dxIF*(IFC +5),IFC + 5)
dis3 = np.linspace(dis2[-1]+dxs,dis2[-1]+dxs*(N-IFC-H),(N-IFC-H))
dis = np.concatenate((dis1,dis2,dis3))
fig = plt.figure('Carrier concentrations')                        #plots ion and electron/holes concentrations throughout the device
ax = fig.add_subplot(1, 1, 1)
ax.set_facecolor('#F1EBFF') 
plotlim = 94
ax.plot(dis[1:plotlim],CELL[0*N+1:0*N+plotlim]/6e26,'k',linewidth = 2)
ax.plot(dis[2:plotlim],CELL[1*N+2:1*N+plotlim]/6e26,'r--',linewidth = 2)
ax.plot(dis[2:plotlim],CELL[2*N+2:2*N+plotlim]/6e26,'b--',linewidth = 2)
plt.xlabel('Distance (nm)', size = '15')
plt.ylabel('Carrier concentrations (M)', size = '15')
plt.xlim(-10,1400)
plt.ylim(-0.003,0.40)
plt.yticks([0,0.1,0.2,0.3])
fig.set_size_inches(10, 7, forward=True)
plt.margins(x=0.1,y=10)
plt.tick_params(length = 10, width = 3, labelsize='25')
#plt.legend(['electrons','cations','anions'])



fig8 = plt.figure('Carrier concentrations 2')                        #plots ion and electron/holes concentrations throughout the device
ax8 = fig8.add_subplot(1, 1, 1)
ax8.set_facecolor('#F1EBFF') 
plotlim = 94
ax8.plot(dis[1:plotlim],CELL2[0*N+1:0*N+plotlim]/6e26,'k',linewidth = 2)
ax8.plot(dis[2:plotlim],CELL2[1*N+2:1*N+plotlim]/6e26,'r--',linewidth = 2)
ax8.plot(dis[2:plotlim],CELL2[2*N+2:2*N+plotlim]/6e26,'b--',linewidth = 2)
plt.xlabel('Distance (nm)', size = '15')
plt.ylabel('Carrier concentrations (M)', size = '15')
plt.xlim(-10,1400)
plt.ylim(-0.003,0.3)
plt.yticks([0,0.1,0.2,0.3])
fig8.set_size_inches(10, 7, forward=True)
plt.margins(x=0.1,y=10)
plt.tick_params(length = 10, width = 3, labelsize='25')
#plt.legend(['electrons','cations','anions'])
#%%
fig2 = plt.figure('ES potential')                        #plots ion and electron/holes concentrations throughout the device 
ax2 = fig2.add_subplot(1, 1, 1)
ax2.plot(dis[0:plotlim],CELL[5*N:5*N+plotlim],'k',linewidth = 2)
ax3 = ax2.twinx()
ax3.plot(dis[0:plotlim],-CELL[4*N:4*N+plotlim],'r',linewidth = 2)
plt.xlabel('Distance (nm)', size = '15')
ax3.set_ylabel('Carrier concentrations (M)',color='r', size = '15')
plt.xlim(-10,1400)
ax2.set_ylim(-0.9,0.0)
ax3.set_yscale('log')
ax3.set_ylim(1e2,1e10)
ax2.set_facecolor('#F1EBFF') 
#plt.yticks([0,0.05,0.1,0.15])
fig2.set_size_inches(10, 7, forward=True)
plt.margins(x=0.1,y=10)
ax2.tick_params(length = 10, width = 3, labelsize='25')
ax3.tick_params(length = 10, width = 3,color='r', labelsize='25',labelcolor='r')

Drift = []
Diff = []
Tot = []
ratio = []
ratioDiff = []
ratioDrift = []
for i in range(1,plotlim):
    Drift.append(-CELL[N+i]*q*mu*CELL[4*N+i-1])
    Diff.append(-kT*mu*(CELL[N+i-1]-CELL[N+i])/dx)
    Tot.append(Drift[-1]+Diff[-1])
    ratioDiff.append(Diff[-1]/Tot[-1])
    ratioDrift.append(Drift[-1]/Tot[-1])
    ratio.append(Drift[-1]/Diff[-1])

fig3 =plt.figure('Currents')
#plt.close('all')
plt.plot(dis[2:25],Drift[1:24])
plt.plot(dis[2:25],Diff[1:24])
plt.plot(dis[2:25],Tot[1:24])
#plt.plot(dis[2:25],-CELL[7*N+2:7*N+25]/2.6e16)

fig4 = plt.figure('Current ratios')
ax4 = fig4.add_subplot(1, 1, 1)
plt.plot(dis[3:30],ratioDrift[2:29],'k')
plt.plot(dis[3:30],ratioDiff[2:29],'b')
ax4.set_xlim(0,800)
ax4.set_facecolor('#F1EBFF') 
fig4.set_size_inches(10, 7, forward=True)
ax4.tick_params(length = 10, width = 3, labelsize='25')